package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.Rules;
import com.hero.objects.GenericObject;
import com.hero.objects.disads.Disadvantage;
import com.hero.ui.widgets.PopupMessage;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class DisadsList extends GenericObjectList {

	private static final long serialVersionUID = -6690029926730835210L;

	public DisadsList() {
		super("Disadvantages", "Cost", "Disadvantage", null, HeroDesigner
				.getActiveHero().getDisads());
	}

	@Override
	public void addObject(GenericObject o) {
		if (HeroDesigner.getActiveHero().isPrefab()) {
			super.addObject(o);
			return;
		}
		boolean ret = true;
		boolean warned = false;
		Rules rules = HeroDesigner.getActiveHero().getRules();
		if (rules.getAvailDisadPointsResponse() > Rules.IGNORE) {
			// check values...
			int total = HeroDesigner.getActiveHero().getDisadsUsed();
			int avail = HeroDesigner.getActiveHero().getDisadPoints();
			if ((total > avail) && (o.getRealCostPreList() > 0)) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"Total points of purchased Disadvantages exceeds available total.",
								rules.getAvailDisadPointsResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getAvailDisadPointsResponse() == Rules.WARN;
			} else if ((total + o.getRealCostPreList() > avail)
					&& (o.getRealCostPreList() > 0)) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This Disadvantage puts the total Disadvantage points used over the available limit.",
								rules.getAvailDisadPointsResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getAvailDisadPointsResponse() == Rules.WARN;
			}
		}
		if (!warned && (rules.getDisadCategoryMaxResponse() > Rules.IGNORE)) {
			String id = o.getXMLID();
			double newVal = o.getRealCostPreList();
			if (newVal > 0) {
				double total = 0;
				for (int i = 0; i < HeroDesigner.getActiveHero().getDisads()
						.size(); i++) {
					GenericObject o2 = HeroDesigner.getActiveHero().getDisads()
							.get(i);
					if (o2.getXMLID().equals(id)) {
						total += o2.getRealCostPreList();
					}
				}
				total += newVal;
				if (total > rules.getDisadCategoryMaxValue()) {
					PopupMessage popup = PopupMessage
							.getInstance(
									HeroDesigner.getAppFrame(),
									this,
									"This Disadvantage puts the total Disadvantage points used for this type of disad over the available limit.",
									rules.getDisadCategoryMaxResponse() == Rules.WARN);
					popup.setVisible(true);
					warned = true;
					ret = rules.getDisadCategoryMaxResponse() == Rules.WARN;
				}
			}
		}
		if (ret) {
			super.addObject(o);
		}
	}

	@Override
	protected boolean checkPaste() {
		if (HeroDesigner.getCopyBuffer() instanceof com.hero.objects.List) {
			com.hero.objects.List list = (com.hero.objects.List) HeroDesigner
					.getCopyBuffer();
			for (int i = 0; i < list.getObjects().size(); i++) {
				if (list.getObjects().get(i) instanceof Disadvantage) {
					continue;
				} else {
					return false;
				}
			}
			return true;
		} else if (HeroDesigner.getCopyBuffer() instanceof Disadvantage) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	protected boolean checkReplace(GenericObject replacement,
			GenericObject replacee) {
		if (HeroDesigner.getActiveHero().isPrefab()) {
			return true;
		}
		boolean ret = true;
		boolean warned = false;
		Rules rules = HeroDesigner.getActiveHero().getRules();
		if (rules.getAvailDisadPointsResponse() > Rules.IGNORE) {
			// check values...
			int total = HeroDesigner.getActiveHero().getDisadsUsed();
			int avail = HeroDesigner.getActiveHero().getDisadPoints();
			if ((total > avail)
					&& (replacement.getRealCostPreList() > replacee
							.getRealCostPreList())) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This edit puts the total Disadvantage points used over the available limit.  You must edit the Disadvantage to be of lower cost.",
								rules.getAvailDisadPointsResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getAvailDisadPointsResponse() == Rules.WARN;
			} else if (total - replacee.getRealCostPreList()
					+ replacement.getRealCostPreList() > avail) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This edit puts the total Disadvantage points used over the available limit.",
								rules.getAvailDisadPointsResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getAvailDisadPointsResponse() == Rules.WARN;
			}
		}
		if (!warned && (rules.getDisadCategoryMaxResponse() > Rules.IGNORE)) {
			String id = replacement.getXMLID();
			double oldVal = replacee.getRealCostPreList();
			double newVal = replacement.getRealCostPreList();
			if (newVal > oldVal) {
				double total = 0;
				for (int i = 0; i < HeroDesigner.getActiveHero().getDisads()
						.size(); i++) {
					GenericObject o = HeroDesigner.getActiveHero().getDisads()
							.get(i);
					if (o.getXMLID().equals(id)) {
						total += o.getRealCostPreList();
					}
				}
				total -= oldVal;
				total += newVal;
				if (total > rules.getDisadCategoryMaxValue()) {
					PopupMessage popup = PopupMessage
							.getInstance(
									HeroDesigner.getAppFrame(),
									this,
									"This edit puts the total Disadvantage points used for this type of disad over the available limit.",
									rules.getDisadCategoryMaxResponse() == Rules.WARN);
					popup.setVisible(true);
					warned = true;
					ret = rules.getDisadCategoryMaxResponse() == Rules.WARN;
				}
			}
		}
		return ret;
	}
}